/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk;

import net.caffeinemc.mods.sodium.client.render.chunk.LocalSectionIndex;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.MeshResultSize;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkJob;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.GraphDirectionSet;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.minecraft.class_1058;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderSection {
    private final RenderRegion region;
    private final int sectionIndex;
    private final int chunkX;
    private final int chunkY;
    private final int chunkZ;
    private long visibilityData = 0L;
    private int incomingDirections;
    private int lastVisibleFrame = -1;
    private int adjacentMask;
    public RenderSection adjacentDown;
    public RenderSection adjacentUp;
    public RenderSection adjacentNorth;
    public RenderSection adjacentSouth;
    public RenderSection adjacentWest;
    public RenderSection adjacentEast;
    private boolean built = false;
    private int flags = 0;
    private class_2586 @Nullable [] globalBlockEntities;
    private class_2586 @Nullable [] culledBlockEntities;
    private class_1058 @Nullable [] animatedSprites;
    @Nullable
    private TranslucentData translucentData;
    @Nullable
    private ChunkJob runningJob = null;
    private long lastMeshResultSize = MeshResultSize.NO_DATA;
    private int pendingUpdateType;
    private long pendingUpdateSince;
    private int lastUploadFrame = -1;
    private int lastSubmittedFrame = -1;
    private boolean disposed;

    public RenderSection(RenderRegion region, int chunkX, int chunkY, int chunkZ) {
        this.chunkX = chunkX;
        this.chunkY = chunkY;
        this.chunkZ = chunkZ;
        int rX = this.getChunkX() & 7;
        int rY = this.getChunkY() & 3;
        int rZ = this.getChunkZ() & 7;
        this.sectionIndex = LocalSectionIndex.pack(rX, rY, rZ);
        this.region = region;
    }

    public RenderSection getAdjacent(int direction) {
        return switch (direction) {
            case 0 -> this.adjacentDown;
            case 1 -> this.adjacentUp;
            case 2 -> this.adjacentNorth;
            case 3 -> this.adjacentSouth;
            case 4 -> this.adjacentWest;
            case 5 -> this.adjacentEast;
            default -> null;
        };
    }

    public void setAdjacentNode(int direction, RenderSection node) {
        this.adjacentMask = node == null ? (this.adjacentMask &= ~GraphDirectionSet.of(direction)) : (this.adjacentMask |= GraphDirectionSet.of(direction));
        switch (direction) {
            case 0: {
                this.adjacentDown = node;
                break;
            }
            case 1: {
                this.adjacentUp = node;
                break;
            }
            case 2: {
                this.adjacentNorth = node;
                break;
            }
            case 3: {
                this.adjacentSouth = node;
                break;
            }
            case 4: {
                this.adjacentWest = node;
                break;
            }
            case 5: {
                this.adjacentEast = node;
                break;
            }
        }
    }

    public int getAdjacentMask() {
        return this.adjacentMask;
    }

    public TranslucentData getTranslucentData() {
        return this.translucentData;
    }

    public void setTranslucentData(TranslucentData translucentData) {
        if (translucentData == null) {
            throw new IllegalArgumentException("new translucentData cannot be null");
        }
        this.translucentData = translucentData;
    }

    public void delete() {
        if (this.runningJob != null) {
            this.runningJob.setCancelled();
            this.runningJob = null;
        }
        this.clearRenderState();
        this.disposed = true;
    }

    public boolean setInfo(@Nullable BuiltSectionInfo info) {
        if (info != null) {
            return this.setRenderState(info);
        }
        return this.clearRenderState();
    }

    private boolean setRenderState(@NotNull BuiltSectionInfo info) {
        boolean prevBuilt = this.built;
        int prevFlags = this.flags;
        long prevVisibilityData = this.visibilityData;
        this.built = true;
        this.flags = info.flags;
        this.visibilityData = info.visibilityData;
        this.globalBlockEntities = info.globalBlockEntities;
        this.culledBlockEntities = info.culledBlockEntities;
        this.animatedSprites = info.animatedSprites;
        return !prevBuilt || prevFlags != this.flags || prevVisibilityData != this.visibilityData;
    }

    private boolean clearRenderState() {
        boolean wasBuilt = this.built;
        this.built = false;
        this.flags = 0;
        this.visibilityData = 0L;
        this.globalBlockEntities = null;
        this.culledBlockEntities = null;
        this.animatedSprites = null;
        return wasBuilt;
    }

    public void setLastMeshResultSize(long size) {
        this.lastMeshResultSize = size;
    }

    public long getLastMeshResultSize() {
        return this.lastMeshResultSize;
    }

    public class_4076 getPosition() {
        return class_4076.method_18676((int)this.chunkX, (int)this.chunkY, (int)this.chunkZ);
    }

    public int getOriginX() {
        return this.chunkX << 4;
    }

    public int getOriginY() {
        return this.chunkY << 4;
    }

    public int getOriginZ() {
        return this.chunkZ << 4;
    }

    public float getSquaredDistance(class_2338 pos) {
        return this.getSquaredDistance((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f, (float)pos.method_10260() + 0.5f);
    }

    public float getSquaredDistance(float x, float y, float z) {
        float xDist = x - (float)this.getCenterX();
        float yDist = y - (float)this.getCenterY();
        float zDist = z - (float)this.getCenterZ();
        return xDist * xDist + yDist * yDist + zDist * zDist;
    }

    public int getCenterX() {
        return this.getOriginX() + 8;
    }

    public int getCenterY() {
        return this.getOriginY() + 8;
    }

    public int getCenterZ() {
        return this.getOriginZ() + 8;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkY() {
        return this.chunkY;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public String toString() {
        return String.format("RenderSection at chunk (%d, %d, %d) from (%d, %d, %d) to (%d, %d, %d)", this.chunkX, this.chunkY, this.chunkZ, this.getOriginX(), this.getOriginY(), this.getOriginZ(), this.getOriginX() + 15, this.getOriginY() + 15, this.getOriginZ() + 15);
    }

    public boolean isBuilt() {
        return this.built;
    }

    public int getSectionIndex() {
        return this.sectionIndex;
    }

    public RenderRegion getRegion() {
        return this.region;
    }

    public void setLastVisibleFrame(int frame) {
        this.lastVisibleFrame = frame;
    }

    public int getLastVisibleFrame() {
        return this.lastVisibleFrame;
    }

    public int getIncomingDirections() {
        return this.incomingDirections;
    }

    public void addIncomingDirections(int directions) {
        this.incomingDirections |= directions;
    }

    public void setIncomingDirections(int directions) {
        this.incomingDirections = directions;
    }

    public int getFlags() {
        return this.flags;
    }

    public long getVisibilityData() {
        return this.visibilityData;
    }

    public class_1058 @Nullable [] getAnimatedSprites() {
        return this.animatedSprites;
    }

    public class_2586 @Nullable [] getCulledBlockEntities() {
        return this.culledBlockEntities;
    }

    public class_2586 @Nullable [] getGlobalBlockEntities() {
        return this.globalBlockEntities;
    }

    @Nullable
    public ChunkJob getRunningJob() {
        return this.runningJob;
    }

    public void setRunningJob(@Nullable ChunkJob token) {
        this.runningJob = token;
    }

    public int getPendingUpdate() {
        return this.pendingUpdateType;
    }

    public long getPendingUpdateSince() {
        return this.pendingUpdateSince;
    }

    public void setPendingUpdate(int type, long now) {
        this.pendingUpdateType = type;
        this.pendingUpdateSince = now;
    }

    public void clearPendingUpdate() {
        this.pendingUpdateType = 0;
    }

    public void prepareTrigger(boolean isDirectTrigger) {
        if (this.translucentData != null) {
            this.translucentData.prepareTrigger(isDirectTrigger);
        }
    }

    public int getLastUploadFrame() {
        return this.lastUploadFrame;
    }

    public void setLastUploadFrame(int lastSortFrame) {
        this.lastUploadFrame = lastSortFrame;
    }

    public int getLastSubmittedFrame() {
        return this.lastSubmittedFrame;
    }

    public void setLastSubmittedFrame(int lastSubmittedFrame) {
        this.lastSubmittedFrame = lastSubmittedFrame;
    }
}

