/*
 * Decompiled with CFR 0.152.
 */
package space.flowproject.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_310;
import org.slf4j.Logger;

final class FlowprojectConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "flowproject.json";
    @SerializedName(value="discordAppId")
    private String discordAppId = "";

    FlowprojectConfig() {
    }

    static FlowprojectConfig load(Logger logger) {
        Path configDir = class_310.method_1551().field_1697.toPath().resolve("config");
        Path file = configDir.resolve(FILE_NAME);
        FlowprojectConfig config = new FlowprojectConfig();
        if (Files.exists(file, new LinkOption[0])) {
            try {
                config = (FlowprojectConfig)GSON.fromJson(Files.readString(file), FlowprojectConfig.class);
                logger.info("FlowProject config loaded from {}", (Object)file);
            }
            catch (Exception e) {
                logger.warn("Failed to read {}, using defaults: {}", (Object)file, (Object)e.getMessage());
            }
        } else {
            try {
                Files.createDirectories(configDir, new FileAttribute[0]);
                Files.writeString(file, (CharSequence)GSON.toJson((Object)config), new OpenOption[0]);
                logger.info("FlowProject created default config at {}", (Object)file);
            }
            catch (IOException e) {
                logger.warn("Failed to write default config {}: {}", (Object)file, (Object)e.getMessage());
            }
        }
        return config;
    }

    String discordAppId() {
        return this.discordAppId;
    }
}

