/*
 * Decompiled with CFR 0.152.
 */
package space.flowproject.client;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_310;
import net.minecraft.class_642;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import space.flowproject.client.CheatReportPayload;
import space.flowproject.client.CheatScanner;
import space.flowproject.client.DiscordRpcManager;
import space.flowproject.client.FlowprojectConfig;

public final class FlowProjectMod
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"flowproject");
    private static final Set<String> TARGET_HOSTS = Set.of("64.188.67.116", "play.flowproject.space");
    private final FlowprojectConfig config = FlowprojectConfig.load(LOGGER);
    private final DiscordRpcManager discord = new DiscordRpcManager(LOGGER, this.config);
    private final CheatScanner scanner = new CheatScanner();

    public void onInitializeClient() {
        PayloadTypeRegistry.playC2S().register(CheatReportPayload.TYPE, CheatReportPayload.CODEC);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> this.handleJoin());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> this.discord.shutdown());
    }

    private void handleJoin() {
        class_310 minecraft = class_310.method_1551();
        class_642 info = minecraft.method_1558();
        if (!this.isTargetServer(info)) {
            LOGGER.debug("FlowProject RPC: server '{}' not in target list, shutting down RPC.", (Object)(info != null ? info.field_3761 : "null"));
            this.discord.shutdown();
            return;
        }
        String playerName = minecraft.method_1548().method_1676();
        this.discord.start(playerName);
        List<String> hits = this.scanner.scan();
        if (!hits.isEmpty()) {
            ClientPlayNetworking.send((class_8710)new CheatReportPayload(hits));
            LOGGER.info("FlowProject: reported suspicious local content to plugin: {}", hits);
        } else {
            LOGGER.debug("FlowProject: no suspicious mods or resource packs detected for flowproject.space");
        }
    }

    private boolean isTargetServer(class_642 info) {
        if (info == null || info.field_3761 == null) {
            return false;
        }
        String address = info.field_3761.toLowerCase(Locale.ROOT);
        String hostOnly = address.contains(":") ? address.substring(0, address.indexOf(58)) : address;
        return TARGET_HOSTS.contains(hostOnly);
    }
}

