/*
 * Decompiled with CFR 0.152.
 */
package space.flowproject.client;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import net.arikia.dev.drpc.DiscordEventHandlers;
import net.arikia.dev.drpc.DiscordRPC;
import net.arikia.dev.drpc.DiscordRichPresence;
import org.slf4j.Logger;
import space.flowproject.client.FlowprojectConfig;

final class DiscordRpcManager {
    private static final String INVITE_URL = "https://discord.gg/j35ajuJczA";
    private static final String DEFAULT_APP_ID = "1464579047937020140";
    private final Logger logger;
    private final FlowprojectConfig config;
    private Thread callbackThread;
    private boolean running;

    DiscordRpcManager(Logger logger, FlowprojectConfig config) {
        this.logger = logger;
        this.config = config;
    }

    void start(String playerName) {
        if (this.running) {
            this.updatePresence(playerName);
            return;
        }
        String appId = this.resolveAppId();
        if (appId == null || appId.isBlank()) {
            this.logger.warn("Discord RPC app id is missing; set -Dflowproject.discord.appId, FLOWPROJECT_DISCORD_APP_ID, or config/flowproject.json");
            return;
        }
        DiscordEventHandlers handlers = new DiscordEventHandlers.Builder().setJoinGameEventHandler(this::openLink).setSpectateGameEventHandler(this::openLink).build();
        DiscordRPC.discordInitialize(appId, handlers, true);
        this.updatePresence(playerName);
        this.running = true;
        this.callbackThread = new Thread(() -> {
            while (this.running) {
                DiscordRPC.discordRunCallbacks();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ignored) {
                    this.running = false;
                    Thread.currentThread().interrupt();
                }
            }
        }, "flowproject-rpc");
        this.callbackThread.setDaemon(true);
        this.callbackThread.start();
        this.logger.info("Discord RPC started for flowproject.space with appId {}", (Object)appId);
    }

    void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        DiscordRPC.discordClearPresence();
        DiscordRPC.discordShutdown();
        this.logger.info("Discord RPC stopped");
    }

    private void updatePresence(String playerName) {
        DiscordRichPresence presence = new DiscordRichPresence();
        presence.details = "Nick: " + playerName;
        presence.state = "Playing on flowproject.space";
        presence.startTimestamp = Instant.now().getEpochSecond();
        presence.largeImageKey = "flowproject";
        presence.largeImageText = "flowproject.space";
        presence.joinSecret = INVITE_URL;
        presence.spectateSecret = INVITE_URL;
        DiscordRPC.discordUpdatePresence(presence);
    }

    private void openLink(String secret) {
        if (secret == null || secret.isBlank()) {
            return;
        }
        try {
            if (!Desktop.isDesktopSupported()) {
                this.logger.warn("Desktop actions unsupported; cannot open invite link");
                return;
            }
            Desktop.getDesktop().browse(new URI(secret));
        }
        catch (IOException | URISyntaxException e) {
            this.logger.warn("Failed to open invite link from Discord RPC: {}", (Object)e.getMessage());
        }
    }

    private String resolveAppId() {
        String sys = System.getProperty("flowproject.discord.appId");
        if (sys != null && !sys.isBlank()) {
            return sys;
        }
        String env = System.getenv("FLOWPROJECT_DISCORD_APP_ID");
        if (env != null && !env.isBlank()) {
            return env;
        }
        String cfg = this.config.discordAppId();
        if (cfg != null && !cfg.isBlank()) {
            return cfg;
        }
        return DEFAULT_APP_ID;
    }
}

