/*
 * Decompiled with CFR 0.152.
 */
package space.flowproject.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_310;
import net.minecraft.class_3288;

final class CheatScanner {
    private static final Set<String> SUSPICIOUS = Set.of("xray", "hack", "cheat", "utility", "bypass", "wurst", "meteor", "aristois", "inertia", "impact", "horion", "wwe", "liquidbounce", "baritone", "killaura");
    private static final Set<String> SAFE_IDS = Set.of("minecraft", "fabricloader", "fabric", "java", "sodium", "lithium", "phosphor", "indium");

    CheatScanner() {
    }

    List<String> scan() {
        ArrayList<String> hits = new ArrayList<String>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            String id = mod.getMetadata().getId();
            String name = mod.getMetadata().getName();
            if (SAFE_IDS.contains(id) || !this.isSuspicious(id) && !this.isSuspicious(name)) continue;
            hits.add("mod:" + id + " (" + name + ")");
        }
        class_310 client = class_310.method_1551();
        client.method_1520().method_14444().forEach(pack -> this.inspectPack((class_3288)pack, (List<String>)hits));
        return hits;
    }

    private void inspectPack(class_3288 pack, List<String> hits) {
        String id = pack.method_14463();
        String title = pack.method_14457().getString();
        if (this.isSuspicious(id) || this.isSuspicious(title)) {
            hits.add("pack:" + id);
        }
    }

    private boolean isSuspicious(String value) {
        if (value == null) {
            return false;
        }
        String lower = value.toLowerCase(Locale.ROOT);
        return SUSPICIOUS.stream().anyMatch(lower::contains);
    }
}

