/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.api.util.v1;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Objects;

public class MethodHandleHelper {
    public static final MethodHandleHelper PUBLIC = new MethodHandleHelper(MethodHandleHelper.class.getClassLoader(), MethodHandles.lookup());
    private final ClassLoader a;
    private final MethodHandles.Lookup b;

    public MethodHandleHelper(ClassLoader classLoader, MethodHandles.Lookup lookup) {
        this.a = classLoader;
        this.b = lookup;
    }

    public static Object firstNonNull(Object ... objectArray) {
        for (Object object : objectArray) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public Class getClassOrNull(String string) {
        try {
            return Class.forName(string, true, this.a);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Class getClassOrNull(String ... stringArray) {
        for (String string : stringArray) {
            try {
                return Class.forName(string, true, this.a);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public MethodHandle getMethodOrNull(Class clazz, String string, Class ... classArray) {
        if (clazz == null || Arrays.stream(classArray).anyMatch(Objects::isNull)) {
            return null;
        }
        try {
            return this.b.unreflect(clazz.getMethod(string, classArray));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    public MethodHandle getMethodOrNull(Class clazz, String string, MethodType methodType, Class ... classArray) {
        if (clazz == null || Arrays.stream(classArray).anyMatch(Objects::isNull)) {
            return null;
        }
        try {
            return this.b.unreflect(clazz.getMethod(string, classArray)).asType(methodType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    public MethodHandle getConstructorOrNull(Class clazz, MethodType methodType) {
        MethodType methodType2 = methodType;
        return this.getConstructorOrNull(clazz, methodType2, methodType2.parameterArray());
    }

    public MethodHandle getConstructorOrNull(Class clazz, MethodType methodType, Class ... classArray) {
        if (clazz == null || Arrays.stream(classArray).anyMatch(Objects::isNull)) {
            return null;
        }
        try {
            return this.b.unreflectConstructor(clazz.getConstructor(classArray)).asType(methodType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    public MethodHandle getGetterOrNull(Class clazz, String string, Class clazz2) {
        if (clazz == null || clazz2 == null) {
            return null;
        }
        try {
            return this.b.findGetter(clazz, string, clazz2);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    public MethodHandle getGetterOrNull(Class clazz, String string, Class clazz2, MethodType methodType) {
        if (clazz == null || clazz2 == null) {
            return null;
        }
        try {
            return this.b.findGetter(clazz, string, clazz2).asType(methodType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    public MethodHandle getSetterOrNull(Class clazz, String string, Class clazz2) {
        if (clazz == null || clazz2 == null) {
            return null;
        }
        try {
            return this.b.findSetter(clazz, string, clazz2);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    public MethodHandle getSetterOrNull(Class clazz, String string, Class clazz2, MethodType methodType) {
        if (clazz == null || clazz2 == null) {
            return null;
        }
        try {
            return this.b.findSetter(clazz, string, clazz2).asType(methodType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }
}

