/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.common.migrate;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.common.Version;
import net.lopymine.patpat.common.migrate.MigrateHandler;

public abstract class AbstractPatPatConfigMigrateManager {
    private final Set<MigrateHandler> handlers = new HashSet<MigrateHandler>();
    private final PatLogger logger;
    private final Version currentGlobalConfigVersion;
    private final Supplier<Version> currentConfigVersionSupplier;

    protected AbstractPatPatConfigMigrateManager(PatLogger logger, Version currentGlobalConfigVersion, Supplier<Version> currentConfigVersionSupplier) {
        this.logger = logger;
        this.currentGlobalConfigVersion = currentGlobalConfigVersion;
        this.currentConfigVersionSupplier = currentConfigVersionSupplier;
    }

    public void migrate() {
        Version globalVersion;
        for (MigrateHandler handler : this.handlers) {
            if (!handler.needMigrate()) continue;
            String migrateVersion = handler.getMigrateVersion();
            if (!handler.migrate()) {
                this.logger.warn("Error migrate config from version: " + migrateVersion, new Object[0]);
                this.logger.warn("Report the issue at github page: {}, attaching your config and specifying the mod and server versions.", "https://github.com/LopyMine/patpat/issues");
                return;
            }
            this.logger.info("Config successful migrated from version: " + migrateVersion, new Object[0]);
        }
        Version currentVersion = this.currentConfigVersionSupplier.get();
        if (currentVersion.is(globalVersion = this.currentGlobalConfigVersion)) {
            return;
        }
        if (currentVersion.isMoreThan(globalVersion)) {
            this.logger.warn("Your config version is higher than the mod's (%s > %s). This may cause errors!".formatted(currentVersion, globalVersion), new Object[0]);
            this.logger.warn("Update the mod to avoid issues.", new Object[0]);
            return;
        }
        this.logger.warn("Your config version is lower than the mod's (%s < %s). This may cause errors!".formatted(currentVersion, globalVersion), new Object[0]);
        this.logger.warn("Back up your config and report the issue at github page: {}, attaching your config and specifying the mod and server versions.", "https://github.com/LopyMine/patpat/issues");
    }

    protected void addHandlers(MigrateHandler ... array) {
        this.handlers.addAll(List.of(array));
    }
}

