/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.common.migrate;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import lombok.Generated;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.common.config.PatPatConfigManager;
import net.lopymine.patpat.common.migrate.MigrateHandler;

public abstract class AbstractConfigMigrateHandler
implements MigrateHandler {
    protected static final Gson GSON = new Gson();
    private final PatLogger logger;
    private String migrateFileName;
    private String migrateVersion;
    private Path configFolder;
    private boolean shouldSave = true;

    protected AbstractConfigMigrateHandler(String migrateFileName, String migrateVersion, PatLogger logger) {
        this.migrateFileName = migrateFileName;
        this.migrateVersion = migrateVersion;
        this.logger = logger;
    }

    protected abstract boolean needToMigrateFile();

    protected abstract boolean migrateFile();

    protected String getBackupFileName() {
        return this.getMigrateFileName() + ".bkp";
    }

    public Path getConfigFolder() {
        return this.configFolder == null ? PatPatConfigManager.CONFIG_PATH : this.configFolder;
    }

    @Override
    public boolean needMigrate() {
        File file = this.getMigrateFile().toFile();
        if (!file.exists()) {
            return false;
        }
        return this.needToMigrateFile();
    }

    @Override
    public boolean migrate() {
        File file = this.getMigrateFile().toFile();
        if (!file.exists()) {
            return false;
        }
        if (!this.createBackup()) {
            return false;
        }
        return this.migrateFile();
    }

    protected boolean createBackup() {
        try {
            Files.copy(this.getMigrateFile(), this.getBackupFile(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.getLogger().error("Failed to create old config backup!", e);
            return false;
        }
        return true;
    }

    protected Path getMigrateFile() {
        return this.getConfigFolder().resolve(this.getMigrateFileName());
    }

    protected Path getBackupFile() {
        return this.getConfigFolder().resolve(this.getBackupFileName());
    }

    @Generated
    public PatLogger getLogger() {
        return this.logger;
    }

    @Generated
    public String getMigrateFileName() {
        return this.migrateFileName;
    }

    @Override
    @Generated
    public String getMigrateVersion() {
        return this.migrateVersion;
    }

    @Generated
    public boolean isShouldSave() {
        return this.shouldSave;
    }

    @Generated
    public void setMigrateFileName(String migrateFileName) {
        this.migrateFileName = migrateFileName;
    }

    @Generated
    public void setMigrateVersion(String migrateVersion) {
        this.migrateVersion = migrateVersion;
    }

    @Generated
    public void setConfigFolder(Path configFolder) {
        this.configFolder = configFolder;
    }

    @Generated
    public void setShouldSave(boolean shouldSave) {
        this.shouldSave = shouldSave;
    }
}

