/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.common.config.list;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.common.config.list.AbstractMapConfig;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPatPatPlayerListConfig
extends AbstractMapConfig<UUID, String> {
    private final Map<UUID, String> values = new HashMap<UUID, String>();

    public AbstractPatPatPlayerListConfig(Map<UUID, String> standardValues, PatLogger logger, File configFile) {
        super(standardValues, logger, configFile);
    }

    public boolean contains(UUID uuid) {
        return this.values.containsKey(uuid);
    }

    @Override
    @Nullable
    protected Map.Entry<UUID, String> decode(String line) {
        try {
            String[] uuidNicknamePair = line.split(" ");
            return Map.entry(UUID.fromString(uuidNicknamePair[0]), uuidNicknamePair[1]);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to parse line \"{}\":", line);
            return null;
        }
    }

    @Override
    @Nullable
    protected String encode(Map.Entry<UUID, String> element) {
        return "%s %s".formatted(element.getKey(), element.getValue());
    }

    @Override
    @Generated
    public Map<UUID, String> getValues() {
        return this.values;
    }
}

